
// Author: Gael Beaunée - www.gaelbn.com

// An implementation of the Conway's Game of Life (http://web.stanford.edu/~cdebs/GameOfLife/) using p5js (https://p5js.org/)


var w;
var columns;
var rows;
var board;
var next;
var theColor;

var simulate = true;
var theBoardWasErased = false;

var interactiveMode = true;
var aCellStateHasBeenUpdated = false;

var theCellWidth = 10;

function setup() {
  frameRate(10);
  // theColor = color(30,125);
  // theColor = color(random(0, 230), random(0, 230), random(0, 230), 125);
  var theRed = random(0, 230);
  theColor = color(theRed, random(theRed, 230), random(theRed, 230), 125);

  var canvas = createCanvas(windowWidth, windowHeight);
  canvas.parent('golSketch-holder_plain');

  w = theCellWidth;
  // Calculate columns and rows
  columns = floor(width/w);
  rows = floor(height/w);
  // Wacky way to make a 2D array is JS
  board = new Array(columns);
  for (var i = 0; i < columns; i++) {
    board[i] = new Array(rows);
  }
  // Going to use multiple 2D arrays and swap them
  next = new Array(columns);
  for (i = 0; i < columns; i++) {
    next[i] = new Array(rows);
  }
  init();
}


function draw() {

  if (simulate) {
    generate();
    drawTheBoard()
  }

  if (theBoardWasErased) {
    background(255);
    simulate = false
    theBoardWasErased = false;
  }

}


// draw the board
function drawTheBoard() {
  background(255,10);
  for ( var i = 0; i < columns;i++) {
    for ( var j = 0; j < rows;j++) {
      if ((board[i][j] == 1)) {
        fill(theColor);
        stroke(255);
        rect(i*w, j*w, w, w);
      }
      else {
        fill(255,30);
        stroke(255,30);
        rect(i*w, j*w, w, w);
      }
    }
  }
  fill(255,50);
  noStroke();
  rect(0, 0, width, height);
}


// reset board when mouse is pressed
function mousePressed() {
  if (interactiveMode) {
    setTheStateOfTheCell(mouseX, mouseY);
  }
}


// reset board when mouse is pressed
function setTheStateOfTheCell(theXPosition, theYPosition) {
  i = floor(theXPosition/theCellWidth);
  j = floor(theYPosition/theCellWidth);
  if (i == 0 || j == 0 || i == columns-1 || j == rows-1) {
    board[i][j] = 0;
    aCellStateHasBeenUpdated = false;
  } else {
    aCellStateHasBeenUpdated = true;
    if (board[i][j] == 0) {
      board[i][j] = 1;
      fill(theColor);
      stroke(255);
      rect(i*w, j*w, w, w);
    } else {
      board[i][j] = 0;
      fill(255);
      stroke(255);
      rect(i*w, j*w, w, w);
    }
  }
}


// Fill board randomly
function init() {
  for (var i = 0; i < columns; i++) {
    for (var j = 0; j < rows; j++) {
      // Lining the edges with 0s
      if (i == 0 || j == 0 || i == columns-1 || j == rows-1) board[i][j] = 0;
      // Filling the rest randomly
      else board[i][j] = floor(random(2));
      next[i][j] = 0;
    }
  }
}


// erase the board
function erase() {
  for (var i = 0; i < columns; i++) {
    for (var j = 0; j < rows; j++) {
      // fill the board with 0s
      board[i][j] = 0;
      next[i][j] = 0;
    }
  }
}


// The process of creating the new generation
function generate() {

  // Loop through every spot in our 2D array and check spots neighbors
  for (var x = 1; x < columns - 1; x++) {
    for (var y = 1; y < rows - 1; y++) {
      // Add up all the states in a 3x3 surrounding grid
      var neighbors = 0;
      for (var i = -1; i <= 1; i++) {
        for (var j = -1; j <= 1; j++) {
          neighbors += board[x+i][y+j];
        }
      }

      // A little trick to subtract the current cell's state since
      // we added it in the above loop
      neighbors -= board[x][y];
      // Rules of Life
      if      ((board[x][y] == 1) && (neighbors <  2)) next[x][y] = 0;           // Loneliness
      else if ((board[x][y] == 1) && (neighbors >  3)) next[x][y] = 0;           // Overpopulation
      else if ((board[x][y] == 0) && (neighbors == 3)) next[x][y] = 1;           // Reproduction
      else                                             next[x][y] = board[x][y]; // Stasis
    }
  }

  // Swap!
  var temp = board;
  board = next;
  next = temp;
}


function keyTyped() {
  if (key === 'c' | key === 'C') {
    theColor = color(random(0, 230), random(0, 230), random(0, 230), 125);
    // var theRed = random(20, 220);
    // theColor = color(theRed, random(theRed, 220), random(theRed, 220), 125);
  }

  if (key === 'r' | key === 'R') {
    // theColor = color(30);
    init();
    simulate = true;
    interactiveMode = false;
  }

  if (key === 'i' | key === 'I') {
    interactiveMode = !interactiveMode;
  }

  if (key === 'p' | key === 'P') {
    simulate = !simulate;
  }

  if (key === 'e' | key === 'E') {
    // theColor = color(30);
    erase();
    simulate = false;
    interactiveMode = true;
    theBoardWasErased = true;
  }
}


// resize the sketch when windows is resized
function windowResized() {
  // canvasDiv = document.getElementById('golSketch-holder');
  // width = canvasDiv.offsetWidth;
  // resizeCanvas(width,width/2);
  createCanvas(windowWidth, windowHeight);

  columns = floor(width/w);
  rows = floor(height/w);
  // Wacky way to make a 2D array is JS
  board = new Array(columns);
  for (var i = 0; i < columns; i++) {
    board[i] = new Array(rows);
  }
  // Going to use multiple 2D arrays and swap them
  next = new Array(columns);
  for (i = 0; i < columns; i++) {
    next[i] = new Array(rows);
  }
  init();
}
